<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function reservations()
    {
        return $this->hasMany('App\Models\Reservation');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function paymentTransaction()
    {
        return $this->hasMany('App\Models\PaymentTransaction');
    }

    public function delivery_reviews()
    {
        return $this->hasMany('App\Models\DeliveryReview');
    }

}